/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : IRQ.h
    Description  : IRQ definitions - ADUCRF101 Version
    Date         : 29 October 2010
    Version      : v1.01
    Changelog    : v1.01 Updated for current silicon
    Changelog    : v1.00 Initial
*/
#ifndef __IRQ_H
#define __IRQ_H

/* Interrupt numbers                                                         */
#define INT_T2            0      // Wake Up Timer  (timer 2)            
#define INT_EXTINT0       1      // External Interrupt 0       
#define INT_EXTINT1       2      // External Interrupt 1       
#define INT_EXTINT2       3      // External Interrupt 2       
#define INT_EXTINT3       4      // External Interrupt 3       
#define INT_EXTINT4       5      // External Interrupt 4       
#define INT_EXTINT5       6      // External Interrupt 5       
#define INT_EXTINT6       7      // External Interrupt 6       
#define INT_EXTINT7       8      // External Interrupt 7       
#define INT_EXTINT8       9      // External Interrupt 8       
#define INT_T3            10     // Watchdog timer handler  (timer 3)   
#define INT_RESRVD11      11     // Reserved
#define INT_T0            12     // General purpose timer 0    
#define INT_T1            13     // General purpose timer 1    
#define INT_ADC           14     // ADC Interrupt              
#define INT_FLSH          15     // Flash IRQ                  
#define INT_UART          16     // UART0                      
#define INT_SPI0          17     // SPI 0                      
#define INT_SPI1          18     // SPI 1                      
#define INT_I2CS          19     // I2C Slave                 
#define INT_I2CM          20     // I2C Master                
#define INT_RESRVD21      21     // Reserved
#define INT_DMAERROR      22     // DMA Error interrupt        
#define INT_DMASPI1TX     23     // DMA SPI 1 TX
#define INT_DMASPI1RX     24     // DMA SPI 1 RX
#define INT_DMAUARTTX     25     // DMA UART TX
#define INT_DMAUARTRX     26     // DMA UART RX
#define INT_DMAI2CSTX     27     // DMA I2C Slave TX
#define INT_DMAI2CSRX     28     // DMA I2C Slave RX
#define INT_DMAI2CMTX     29     // DMA I2C Master TX
#define INT_DMAI2CMRX     30     // DMA I2C Master RX
#define INT_DMARESRVD31   31     // DMA Reserved
#define INT_DMARESRVD32   32     // DMA Reserved
#define INT_DMARESRVD33   33     // DMA Reserved
#define INT_DMAADC        34     // DMA ADC
#define INT_DMASPI0TX     35     // DMA SPI0 TX
#define INT_DMASPI0RX     36     // DMA SPI0 RX
#define INT_PWMTRIP       37     // PWM Trip
#define INT_PWM0          38     // PWM 0
#define INT_PWM1          39     // PWM 1
#define INT_PWM2          40     // PWM 2
#define INT_PWM3          41     // PWM 3
#define INT_RESRVD42      42     // Reserved
                                 
#endif
